/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomRegisters;
import noppes.npcs.EventHooks;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.ILayerModel;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.block.ITextPlane;
import noppes.npcs.api.wrapper.BlockScriptedWrapper;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.IScriptBlockHandler;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.entity.data.DataTimers;
import noppes.npcs.entity.data.TextBlock;
import noppes.npcs.util.LayerModel;
import noppes.npcs.util.ValueUtil;

public class TileScripted
extends TileNpcEntity
implements ITickable,
IScriptBlockHandler {
    public int activePowering = 0;
    private IBlock blockDummy = null;
    public float blockHardness = 5.0f;
    public Block blockModel = null;
    public float blockResistance = 10.0f;
    public boolean enabled = false;
    public boolean isLadder = false;
    public boolean isPassable = false;
    public ItemStack itemModel;
    public int metaModel = 0;
    public long lastInited = -1L;
    public int lightValue = 0;
    public boolean needsClientUpdate = false;
    public int newPower = 0;
    public int powering = 0;
    public int prevPower = 0;
    public TileEntity renderTile;
    public boolean renderTileErrored = true;
    public ITickable renderTileUpdate = null;
    public int rotationX = 0;
    public int rotationY = 0;
    public int rotationZ = 0;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    public String scriptLanguage = "ECMAScript";
    public List<ScriptContainer> scripts = new ArrayList<ScriptContainer>();
    public TextPlane text1;
    public TextPlane text2;
    public TextPlane text3;
    public TextPlane text4;
    public TextPlane text5;
    public TextPlane text6;
    private short ticksExisted = 0;
    public DataTimers timers = new DataTimers(this);
    public ILayerModel[] layers;

    public TileScripted() {
        this.itemModel = new ItemStack(CustomRegisters.scripted);
        this.text1 = new TextPlane();
        this.text2 = new TextPlane();
        this.text3 = new TextPlane();
        this.text4 = new TextPlane();
        this.text5 = new TextPlane();
        this.text6 = new TextPlane();
        this.layers = new ILayerModel[0];
    }

    @Override
    public void clearConsole() {
        for (ScriptContainer script : this.getScripts()) {
            script.console.clear();
        }
    }

    @Override
    public IBlock getBlock() {
        if (this.blockDummy == null) {
            this.blockDummy = new BlockScriptedWrapper(this.func_145831_w(), this.func_145838_q(), this.func_174877_v());
        }
        return this.blockDummy;
    }

    @Override
    public TreeMap<Long, String> getConsoleText() {
        TreeMap<Long, String> map = new TreeMap<Long, String>();
        int tab = 0;
        for (ScriptContainer script : this.getScripts()) {
            ++tab;
            for (Map.Entry<Long, String> entry : script.console.entrySet()) {
                String log = map.containsKey(entry.getKey()) ? map.get(entry.getKey()) + "\n\nScriptTab " + tab + ":\n" + entry.getValue() : " ScriptTab " + tab + ":\n" + entry.getValue();
                map.put(entry.getKey(), log);
            }
        }
        return map;
    }

    @Override
    public void clearConsoleText(Long key) {
        for (ScriptContainer script : this.getScripts()) {
            script.console.remove(key);
        }
    }

    public void writeDisplayNBT(NBTTagCompound compound) {
        NBTTagCompound stackcompound = new NBTTagCompound();
        this.itemModel.func_77955_b(stackcompound);
        if (this.blockModel != null) {
            ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.blockModel);
            compound.func_74778_a("ScriptBlockModelBlock", resourcelocation.toString());
        }
        compound.func_74782_a("ScriptBlockModel", (NBTBase)stackcompound);
        compound.func_74768_a("LightValue", this.lightValue);
        compound.func_74757_a("IsLadder", this.isLadder);
        compound.func_74757_a("IsPassable", this.isPassable);
        compound.func_74768_a("RotationX", this.rotationX);
        compound.func_74768_a("RotationY", this.rotationY);
        compound.func_74768_a("RotationZ", this.rotationZ);
        compound.func_74776_a("ScaleX", this.scaleX);
        compound.func_74776_a("ScaleY", this.scaleY);
        compound.func_74776_a("ScaleZ", this.scaleZ);
        compound.func_74782_a("Text1", (NBTBase)this.text1.getNBT());
        compound.func_74782_a("Text2", (NBTBase)this.text2.getNBT());
        compound.func_74782_a("Text3", (NBTBase)this.text3.getNBT());
        compound.func_74782_a("Text4", (NBTBase)this.text4.getNBT());
        compound.func_74782_a("Text5", (NBTBase)this.text5.getNBT());
        compound.func_74782_a("Text6", (NBTBase)this.text6.getNBT());
        compound.func_74768_a("ModelMeta", this.metaModel);
        NBTTagList l = new NBTTagList();
        for (ILayerModel layer : this.layers) {
            l.func_74742_a((NBTBase)layer.getNbt().getMCNBT());
        }
        compound.func_74782_a("Layers", (NBTBase)l);
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public String getLanguage() {
        return this.scriptLanguage;
    }

    public NBTTagCompound getNBT(NBTTagCompound compound) {
        compound.func_74782_a("Scripts", (NBTBase)NBTTags.NBTScript(this.scripts));
        compound.func_74778_a("ScriptLanguage", this.scriptLanguage);
        compound.func_74757_a("ScriptEnabled", this.enabled);
        compound.func_74768_a("BlockPowering", this.powering);
        compound.func_74768_a("BlockPrevPower", this.prevPower);
        compound.func_74776_a("BlockHardness", this.blockHardness);
        compound.func_74776_a("BlockResistance", this.blockResistance);
        compound.func_74768_a("BlockMeta", this.metaModel);
        return compound;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return Block.field_185505_j.func_186670_a(this.func_174877_v());
    }

    @Override
    public List<ScriptContainer> getScripts() {
        return this.scripts;
    }

    public IBlockState getState() {
        IBlockState state = null;
        if (this.blockModel != null && this.itemModel != null) {
            state = this.blockModel.func_176203_a(this.itemModel.func_77952_i());
            if (this.metaModel > 0) {
                try {
                    state = this.blockModel.func_176203_a(this.metaModel);
                    int i = 0;
                    for (IBlockState ibs : this.blockModel.func_176194_O().func_177619_a()) {
                        if (i == this.metaModel) {
                            state = ibs;
                            break;
                        }
                        ++i;
                    }
                    if (state != null) {
                        this.blockModel = state.func_177230_c();
                    }
                }
                catch (Exception e) {
                    this.metaModel = 0;
                }
            }
        }
        return state;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("x", this.field_174879_c.func_177958_n());
        compound.func_74768_a("y", this.field_174879_c.func_177956_o());
        compound.func_74768_a("z", this.field_174879_c.func_177952_p());
        this.writeDisplayNBT(compound);
        this.getNBT(compound);
        return compound;
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        int light = this.lightValue;
        this.setDisplayNBT(tag);
        this.setNBT(tag);
        if (light != this.lightValue) {
            this.field_145850_b.func_175664_x(this.field_174879_c);
        }
    }

    @Override
    public boolean isClient() {
        return this.func_145831_w().field_72995_K;
    }

    public boolean isEnabled() {
        return this.enabled && ScriptController.HasStart && !this.scripts.isEmpty();
    }

    @Override
    public ITextComponent noticeString(String type, Object event) {
        TextComponentString message = new TextComponentString("");
        message.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        if (type != null) {
            TextComponentString hook = new TextComponentString("Hook \"");
            hook.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString hookType = new TextComponentString(type);
            hookType.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString hookEnd = new TextComponentString("\"; ");
            hookEnd.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            message = message.func_150257_a((ITextComponent)hook).func_150257_a((ITextComponent)hookType).func_150257_a((ITextComponent)hookEnd);
        }
        BlockPos pos = this.func_174877_v();
        TextComponentString mesBlock = new TextComponentString("Scripted Block in ");
        mesBlock.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int dimID = this.field_145850_b == null ? 0 : this.field_145850_b.field_73011_w.getDimension();
        TextComponentString posClick = new TextComponentString("dimension ID:" + dimID + "; X:" + x + "; Y:" + y + "; Z:" + z);
        posClick.func_150256_b().func_150238_a(TextFormatting.BLUE).func_150228_d(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/noppes world tp @p " + dimID + " " + x + " " + (y + 1) + " " + z)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("script.hover.error.pos.tp", new Object[0])));
        TextComponentString side = new TextComponentString("; Side: " + (this.isClient() ? "Client" : "Server"));
        side.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        return message.func_150257_a((ITextComponent)mesBlock).func_150257_a((ITextComponent)posClick).func_150257_a((ITextComponent)side);
    }

    public void onDataPacket(@Nonnull NetworkManager net, @Nonnull SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    @Override
    public void runScript(String type, Event event) {
        if (!this.isEnabled()) {
            return;
        }
        if (ScriptController.Instance.lastLoaded > this.lastInited) {
            this.lastInited = ScriptController.Instance.lastLoaded;
            if (!type.equalsIgnoreCase(EnumScriptType.INIT.function)) {
                EventHooks.onScriptBlockInit(this);
            }
        }
        for (ScriptContainer script : this.scripts) {
            script.run(type, event);
        }
    }

    public void setDisplayNBT(NBTTagCompound compound) {
        this.itemModel = new ItemStack(compound.func_74775_l("ScriptBlockModel"));
        if (this.itemModel.func_190926_b()) {
            this.itemModel = new ItemStack(CustomRegisters.scripted);
        }
        if (compound.func_74764_b("ScriptBlockModelBlock")) {
            this.blockModel = Block.func_149684_b((String)compound.func_74779_i("ScriptBlockModelBlock"));
        }
        this.renderTileUpdate = null;
        this.renderTile = null;
        this.renderTileErrored = false;
        this.lightValue = compound.func_74762_e("LightValue");
        this.isLadder = compound.func_74767_n("IsLadder");
        this.isPassable = compound.func_74767_n("IsPassable");
        this.rotationX = compound.func_74762_e("RotationX");
        this.rotationY = compound.func_74762_e("RotationY");
        this.rotationZ = compound.func_74762_e("RotationZ");
        this.scaleX = compound.func_74760_g("ScaleX");
        this.scaleY = compound.func_74760_g("ScaleY");
        this.scaleZ = compound.func_74760_g("ScaleZ");
        if (this.scaleX <= 0.0f) {
            this.scaleX = 1.0f;
        }
        if (this.scaleY <= 0.0f) {
            this.scaleY = 1.0f;
        }
        if (this.scaleZ <= 0.0f) {
            this.scaleZ = 1.0f;
        }
        if (compound.func_74764_b("Text3")) {
            this.text1.setNBT(compound.func_74775_l("Text1"));
            this.text2.setNBT(compound.func_74775_l("Text2"));
            this.text3.setNBT(compound.func_74775_l("Text3"));
            this.text4.setNBT(compound.func_74775_l("Text4"));
            this.text5.setNBT(compound.func_74775_l("Text5"));
            this.text6.setNBT(compound.func_74775_l("Text6"));
        }
        this.metaModel = compound.func_74762_e("ModelMeta");
        this.layers = new ILayerModel[compound.func_150295_c("Layers", 10).func_74745_c()];
        for (int i = 0; i < compound.func_150295_c("Layers", 10).func_74745_c(); ++i) {
            this.layers[i] = new LayerModel(compound.func_150295_c("Layers", 10).func_150305_b(i));
        }
    }

    @Override
    public void setEnabled(boolean bo) {
        this.enabled = bo;
    }

    public void setItemModel(ItemStack item, Block b) {
        if (item == null || item.func_190926_b()) {
            item = new ItemStack(CustomRegisters.scripted);
        }
        if (NoppesUtilPlayer.compareItems(item, this.itemModel, false, false) && b != this.blockModel) {
            return;
        }
        this.itemModel = item;
        this.metaModel = b != null ? item.func_77952_i() : 0;
        this.blockModel = b;
        this.needsClientUpdate = true;
    }

    public void setItemModel(ItemStack item, Block b, int meta) {
        this.setItemModel(item, b);
        this.metaModel = meta;
    }

    @Override
    public void setLanguage(String lang) {
        this.scriptLanguage = lang;
    }

    @Override
    public void setLastInited(long timeMC) {
        this.lastInited = timeMC;
    }

    public void setLightValue(int value) {
        if (value == this.lightValue) {
            return;
        }
        this.lightValue = ValueUtil.correctInt(value, 0, 15);
        this.needsClientUpdate = true;
    }

    public void setRedstonePower(int strength) {
        int correctInt;
        if (this.powering == strength) {
            return;
        }
        this.activePowering = correctInt = ValueUtil.correctInt(strength, 0, 15);
        this.prevPower = correctInt;
        this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), false);
        this.powering = this.activePowering;
    }

    public void setRotation(int x, int y, int z) {
        if (this.rotationX == x && this.rotationY == y && this.rotationZ == z) {
            return;
        }
        this.rotationX = ValueUtil.correctInt(x, 0, 359);
        this.rotationY = ValueUtil.correctInt(y, 0, 359);
        this.rotationZ = ValueUtil.correctInt(z, 0, 359);
        this.needsClientUpdate = true;
    }

    public void setScale(float x, float y, float z) {
        if (this.scaleX == x && this.scaleY == y && this.scaleZ == z) {
            return;
        }
        this.scaleX = ValueUtil.correctFloat(x, 0.0f, 10.0f);
        this.scaleY = ValueUtil.correctFloat(y, 0.0f, 10.0f);
        this.scaleZ = ValueUtil.correctFloat(z, 0.0f, 10.0f);
        this.needsClientUpdate = true;
    }

    public void func_73660_a() {
        if (this.renderTileUpdate != null) {
            try {
                this.renderTileUpdate.func_73660_a();
            }
            catch (Exception e) {
                this.renderTileUpdate = null;
            }
        }
        this.ticksExisted = (short)(this.ticksExisted + 1);
        if (this.prevPower != this.newPower && this.powering <= 0) {
            EventHooks.onScriptBlockRedstonePower(this, this.prevPower, this.newPower);
            this.prevPower = this.newPower;
        }
        this.timers.update();
        if (this.ticksExisted >= 10) {
            if (this.isEnabled()) {
                ScriptController.Instance.tryAdd(0, this);
                EventHooks.onScriptBlockUpdate(this);
            }
            this.ticksExisted = 0;
        }
        if (this.needsClientUpdate) {
            this.func_70296_d();
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.needsClientUpdate = false;
        }
    }

    public void setNBT(NBTTagCompound compound) {
        int pw;
        this.scripts = NBTTags.GetScript(compound.func_150295_c("Scripts", 10), this, false);
        this.scriptLanguage = compound.func_74779_i("ScriptLanguage");
        this.enabled = compound.func_74767_n("ScriptEnabled");
        this.powering = pw = compound.func_74762_e("BlockPowering");
        this.activePowering = pw;
        this.prevPower = compound.func_74762_e("BlockPrevPower");
        if (compound.func_74764_b("BlockHardness")) {
            this.blockHardness = compound.func_74760_g("BlockHardness");
            this.blockResistance = compound.func_74760_g("BlockResistance");
        }
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.setNBT(compound);
        this.setDisplayNBT(compound);
        this.timers.readFromNBT(compound);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        this.getNBT(compound);
        this.writeDisplayNBT(compound);
        this.timers.writeToNBT(compound);
        super.func_189515_b(compound);
        return compound;
    }

    public class TextPlane
    implements ITextPlane {
        public float offsetX = 0.0f;
        public float offsetY = 0.0f;
        public float offsetZ = 0.5f;
        public int rotationX = 0;
        public int rotationY = 0;
        public int rotationZ = 0;
        public float scale = 1.0f;
        public String text = "";
        public TextBlock textBlock;
        public boolean textHasChanged = true;

        public NBTTagCompound getNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("Text", this.text);
            compound.func_74768_a("RotationX", this.rotationX);
            compound.func_74768_a("RotationY", this.rotationY);
            compound.func_74768_a("RotationZ", this.rotationZ);
            compound.func_74776_a("OffsetX", this.offsetX);
            compound.func_74776_a("OffsetY", this.offsetY);
            compound.func_74776_a("OffsetZ", this.offsetZ);
            compound.func_74776_a("Scale", this.scale);
            return compound;
        }

        @Override
        public float getOffsetX() {
            return this.offsetX;
        }

        @Override
        public float getOffsetY() {
            return this.offsetY;
        }

        @Override
        public float getOffsetZ() {
            return this.offsetZ;
        }

        @Override
        public int getRotationX() {
            return this.rotationX;
        }

        @Override
        public int getRotationY() {
            return this.rotationY;
        }

        @Override
        public int getRotationZ() {
            return this.rotationZ;
        }

        @Override
        public float getScale() {
            return this.scale;
        }

        @Override
        public String getText() {
            return this.text;
        }

        public void setNBT(NBTTagCompound compound) {
            this.setText(compound.func_74779_i("Text"));
            this.rotationX = compound.func_74762_e("RotationX");
            this.rotationY = compound.func_74762_e("RotationY");
            this.rotationZ = compound.func_74762_e("RotationZ");
            this.offsetX = compound.func_74760_g("OffsetX");
            this.offsetY = compound.func_74760_g("OffsetY");
            this.offsetZ = compound.func_74760_g("OffsetZ");
            this.scale = compound.func_74760_g("Scale");
        }

        @Override
        public void setOffsetX(float x) {
            if (this.offsetX == (x = ValueUtil.correctFloat(x, -1.0f, 1.0f))) {
                return;
            }
            this.offsetX = x;
            TileScripted.this.needsClientUpdate = true;
        }

        @Override
        public void setOffsetY(float y) {
            if (this.offsetY == (y = ValueUtil.correctFloat(y, -1.0f, 1.0f))) {
                return;
            }
            this.offsetY = y;
            TileScripted.this.needsClientUpdate = true;
        }

        @Override
        public void setOffsetZ(float z) {
            if (this.offsetZ == (z = ValueUtil.correctFloat(z, -1.0f, 1.0f))) {
                return;
            }
            this.offsetZ = z;
            TileScripted.this.needsClientUpdate = true;
        }

        @Override
        public void setRotationX(int x) {
            if (this.rotationX == (x = ValueUtil.correctInt(x % 360, 0, 359))) {
                return;
            }
            this.rotationX = x;
            TileScripted.this.needsClientUpdate = true;
        }

        @Override
        public void setRotationY(int y) {
            if (this.rotationY == (y = ValueUtil.correctInt(y % 360, 0, 359))) {
                return;
            }
            this.rotationY = y;
            TileScripted.this.needsClientUpdate = true;
        }

        @Override
        public void setRotationZ(int z) {
            if (this.rotationZ == (z = ValueUtil.correctInt(z % 360, 0, 359))) {
                return;
            }
            this.rotationZ = z;
            TileScripted.this.needsClientUpdate = true;
        }

        @Override
        public void setScale(float scale) {
            if (this.scale == scale) {
                return;
            }
            this.scale = scale;
            TileScripted.this.needsClientUpdate = true;
        }

        @Override
        public void setText(String text) {
            if (this.text.equals(text)) {
                return;
            }
            this.text = text;
            this.textHasChanged = true;
            TileScripted.this.needsClientUpdate = true;
        }
    }
}

